/* SI 413 Fall 2011
 * C++ header file for the SymbolTable class
 * Supports dynamic scope
 */

#ifndef ST_HPP
#define ST_HPP

#include <iostream>
#include <map>
#include <string>
using namespace std;

#include "value.hpp"

/* This class represents a simple global symbol table.
 * Later we will extend it to support dynamic scoping.
 */
class SymbolTable {
  private:
    // The actual map. It is declared private, so it can only
    // be accessed via the public methods below.
    map<string,Value> bindings;

  public:
    // Creates a new, empty symbol table
    SymbolTable() { }

    // Returns the Value bound to the given name.
    Value lookup(string name);

    // Creates a new name-value binding
    void bind(string name, Value val = Value());

    // Re-defines the value bound to the given name.
    void rebind(string name, Value val);
};

// This global variable is the actual global symbol table object.
// It is actually declared in the st.cpp file, so we put keyword "extern"
// here.
extern SymbolTable ST;

#endif // ST_HPP
