/* SI 413 Fall 2011
 * Implementations of SymbolTable methods
 */

#include "st.hpp"

SymbolTable ST; // The actual declaration of the global symbol table

Value SymbolTable::lookup(string name) {
  if (bindings.count(name) == 0) {
    cerr << "No binding for variable " << name << endl;
    return Value();
  }
  else return bindings[name];
}

void SymbolTable::bind(string name, Value val) {
  if (bindings.count(name) != 0) {
    cerr << "Variable " << name << " already bound!" << endl;
    return;
  }
  else bindings[name] = val;
}

void SymbolTable::rebind(string name, Value val) {
  if (bindings.count(name) == 0) {
    cerr << "Can't rebind " << name << "; not yet bound!" << endl;
    return;
  }
  else bindings[name] = val;
}
