# SD212 12-Week Practice (Spring 2024)

These are **sample solutions** meant to be looked at *after* you try the
problems yourself.

I really mean it; if you don't force yourself to try actually working
through these problems first, you won't gain much benefit by looking at
these sample solutions.

Keep in mind there are (almost) always multiple correct ways to solve
the same problem.

1.  See `p1-pandas.py` or `p1-dicts.py`. The pandas solution is better
    and that is the recommended approach like we learned in class.

2.  See `p2-pandas.py` and `p2-bash.sh`.
    (Alternative, less good Python version is in `p2-dicts.py`.)

3.  See `p3-soln.sh`

4.  See `p4-soln.py`

    Note that for this problem, *multi-threading* makes more sense than
    multi-processing. That is because it is an IO-bound program (so
    multi-threading is not hampered by the global interpreter lock) and
    the threads need to communicate back to the parent (most easily
    handled using shared memory).

    However, it is also possible to do this one using multi-processing
    and a SimpleQueue.

5.  See `p5-soln.py`

    Note that for this one, you *must* use multi-processing because it
    is CPU-bound.

6.  CPU: Performs all of the math, comparisons, and logic

    Memory: Holds variable values while the program is running

    Disk: Stores file created at the end

    I/O: Keyboard input at the beginning, as well as output to the
    terminal screen

7.  When the real time exceeds user time in a single-threaded program,
    that means there is some kind of waiting going on in the code, most
    often caused by I/O.

    In this program, that is most likely from waiting for the user to
    tyope something on the first line, and possibly has a small
    contribution from waiting for the OS to open and write to the file
    on disk at the end.

8.  This program just has a few (small) variable, and so is only using a
    very small fraction of RAM. More of that won't be helpful for this
    program to improve performance.

9.  A few things that would work:

    *   Rewrite the while loop using numpy or another efficient Python
        library
    *   Parallelize the code using multi-processing. (It is a CPU-bound
        progarm, so multi-threading won't help due to Python's GIL.)
    *   Get someone to rewrite the code in a compiled language like
        C, C++, or Rust, which generally have less overhead and better
        optimizations than interpreted languages like Python.

10. It would need to first load the values of variables s and n from
    memory, then perform two arithmetic operations to square n and add
    that to s, and finally a memory store operation to save this value
    back to memory for the new value of s.

11. Places where the repo files are stored:

    *   Batman's working directory on his laptop
    *   Batman's local repo on his laptop
    *   (same two places for Robin or any other collaborator)
    *   Remote repo on github

12. Commands to add `cave.txt` and upload to github:

        git add cave.txt
        git commit -m "Gotham needs me"
        git push

13. Commands to add `gotham.txt` and then sync in Batman's changes too:

        # first add/commit local changes
        git add gotham.txt
        git commit -m "Robin added gotham"

        # incorporate local changes with updates on the remote
        git fetch
        git merge
        # OR both fetch and merge at once: git pull

        # now sync back all changes to remote
        git push
