/* test_sparsepoly.cc
 * Daniel S. Roche, January 2011
 * See COPYING.txt for permissions.
 *
 * Simple tests for SparsePoly class
 */

#include <complex>
#include <iostream>
#include <fstream>
#include "misc.h"
#include "sparsepoly.h"

using namespace std;
using namespace NTL;

int main (void) {
  cout << "********************************************************************************" << endl
       << "                             SPARSEPOLY TEST" << endl
       << "********************************************************************************" << endl;
  randseed();

  cout.precision(2);

  vector< complex<double> > a,b;
  SparsePoly<double> c,d;
  RandomGen<double> rg;
  double epsilon = .7;

  random(a,20,rg);
  cout << a << endl;
  conv(c,a,epsilon);
  conv(b,c);
  cout << b << endl;
  cout << "tms(a," << epsilon << "): " << sparsity(a,epsilon)
       << ", tms(c): " << c.rep.size()
       << endl;
  cout << (equal(a,b,epsilon) ? "equal" : "unequal") << endl;
  cout << endl;
  if (!equal(a,b,epsilon) || c.rep.size() > sparsity(a,epsilon)) {
    cout << "FAIL" << endl;
    return 1;
  }

  random(c,to_ZZ(2000),10,rg);
  cout << c << endl;
  conv(a,c);
  conv(d,a,epsilon);
  cout << d << endl;
  cout << (equal(c,d,epsilon) ? "equal" : "unequal") << endl;
  cout << "tms(a): " << sparsity(a,epsilon)
       << ", tms(c): " << c.rep.size()
       << endl;
  if (!equal(c,d,epsilon) || sparsity(a,epsilon) > c.rep.size()) {
    cout << "FAIL" << endl;
    return 2;
  }
  cout << "SUCCESS" << endl;
  return 0;
}
