/* test_GSinterp.cc
 * Daniel S. Roche, January 2011
 * See COPYING.txt for permissions.
 *
 * Run some small tests of our implementation of Garg & Schost's 
 * interpolation algorithm.
 */

#include <iostream>
#include <NTL/ZZ.h>
#include <NTL/lzz_p.h>
#include "misc.h"
#include "GSinterp.h"

NTL_CLIENT

int main (int argc, char** argv) {
  cout << "********************************************************************************" << endl
       << "                             GARG & SCHOST TEST" << endl
       << "********************************************************************************" << endl;
  ZZ D;
  long T;
  unsigned long which;

  if (argc >= 2) which = strtoul(argv[1],NULL,2);
  else which = 7;

  if (which <= 0 || which > 7 || argc == 3 || argc > 4 ) {
    cout << "Usage: " << argv[0] << " [which-tests [degree-bound sparsity-bound]]" << endl
         << "\twhich-tests indicates which algorithms to test among:" << endl
         << "\t\t0: Deterministic algorithm" << endl
         << "\t\t1: Probabilistic method A" << endl
         << "\t\t2: Probabilistic method B" << endl
         << "\tby writing 1 for that bit. So e.g. 100 means test probabilistic B only."
         << endl;
    return 1;
  }

  if (argc == 4) {
    conv(D,argv[2]);
    T = strtol(argv[3],NULL,10);
  }
  else {
    conv(D,"1000000");
    T = 5;
    cout << "D = " << D << " ; T = " << T << endl;
  }

  randseed();
  zz_p::init(23);
  SparsePoly<zz_pX,zz_p> f;
  random(f,D,T);
  cout << "orig\t" << f << endl << endl;
  FakeUniModBB<zz_pX,zz_p> bb(f);

  if (which & 1) {
    cout << "==================== Deterministic Algorithm ===================================" << endl;
    SparsePoly<zz_pX,zz_p> out;
    gs_determ_interp (out, bb, D, T);
    cout << out << endl;
    if (f != out) {
      cout << "FAIL" << endl;
      return 2;
    }
  }

  if (which & 2) {
    cout << "==================== Probabilistic method A  ===================================" << endl;
    SparsePoly<zz_pX,zz_p> out;
    gs_prob_interpA (out, bb, D, T);
    cout << out << endl;
    if (f != out) {
      cout << "FAIL" << endl;
      return 3;
    }
  }

  if (which & 4) {
    cout << "==================== Probabilistic method B  ===================================" << endl;
    SparsePoly<zz_pX,zz_p> out;
    gs_prob_interpB (out, bb, D, T);
    cout << out << endl;
    if (f != out) {
      cout << "FAIL" << endl;
      return 4;
    }
  }

  cout << "SUCCESS" << endl;
  return 0;
}
