# see p2-pandas.py for a better solution!

from csv import DictReader, DictWriter

# outrows will be a list of (population, row) tuples
outrows = []

# open input file and loop through, adding to outrows
rdr = DictReader(open('badcities.csv', newline=''))
for row in rdr:
    if row['state'] == '':
        continue
    if row['population'] == '':
        row['population'] = 10000
    else:
        row['population'] = int(row['population'])
    outrows.append((row['population'], row))

# sort tuples by population
# (works because the first tuple element is the thing to sort by)
outrows.sort()

# open output file and write each row
with open('goodcities.csv', 'w', newline='') as fout:
    wtr = DictWriter(fout, rdr.fieldnames)
    wtr.writeheader()
    for _, row in outrows:
        wtr.writerow(row)
