from threading import Thread

# global variable will hold tuples of
# (file_length, file_name)
# We put the file_length first in the tuple so that
# sorting will be based on this number.
file_lengths = []

def count_lines(fname):
    global file_lengths
    # open the file and count the lines
    count = 0
    for line in open(fname):
        count += 1
    # update the global variable
    file_lengths.append((count, fname))

if __name__ == '__main__':
    # start a thread for each file
    children = []
    for n in range(1, 11):
        fname = f'file{n}.txt'
        child = Thread(target=count_lines, args=[fname])
        child.start()
        children.append(child)

    # wait for all threads to finish
    for child in children:
        child.join()

    # compute the result using the shared global variable
    _, name = max(file_lengths)
    print(name)
